/**
* \file: DummyMediaPlaybackStatusImpl.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto
*
* \author: D. Girnus / ADIT/SW2 / dgirnus@de.adit-jv.com
*
* \copyright (c) 2016 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#include <adit_logging.h>
#include "DummyMediaPlaybackStatusImpl.h"

LOG_IMPORT_CONTEXT(aauto_media_pb_status)


namespace adit { namespace aauto {


DummyMediaPlaybackStatusImpl::DummyMediaPlaybackStatusImpl(
        MediaPlaybackStatusEndpoint* inEndpoint, void* inSessionContext)
{
    mEndpoint = inEndpoint;
    mSessionContext = inSessionContext;
    mCallbacks = nullptr;
}

DummyMediaPlaybackStatusImpl::~DummyMediaPlaybackStatusImpl()
{
    shutdown();
}

void DummyMediaPlaybackStatusImpl::setConfigItem(std::string inKey, std::string inValue)
{
    // No configuration is needed for now, so the empty implementation
    (void) inKey;
    (void) inValue;
}

void DummyMediaPlaybackStatusImpl::registerCallbacks(
        IAditMediaPlaybackStatusCallbacks* inCallbacks)
{
    mCallbacks = inCallbacks;
}

bool DummyMediaPlaybackStatusImpl::init()
{
    mEndpoint->registerCallbacks(this);
    return true;
}

void DummyMediaPlaybackStatusImpl::shutdown()
{
    LOGD_DEBUG((aauto_media_pb_status, "%s() shut down", __FUNCTION__));
    // nothing to do
}

int DummyMediaPlaybackStatusImpl::mediaPlaybackStatusCallback(
        struct MediaPlaybackStatusStruct inStatus)
{
    // state 1: Stopped, 2: Playing, 3: Paused
    LOGD_VERBOSE((aauto_media_pb_status, "Media Playback Status: State= %d; Media "
            "Source= %s; Playback Seconds= %d; Shuffle= %d; Repeat= %d; Repeat"
            "One= %d", inStatus.state, inStatus.media_source.c_str(),
            inStatus.playback_seconds, inStatus.shuffle, inStatus.repeat,
            inStatus.repeat_one));
    return mCallbacks->mediaPlaybackStatusCallback(inStatus);
}

int DummyMediaPlaybackStatusImpl::mediaPlaybackMetadataCallback(
        struct MediaPlaybackMetadataStruct inMetadata)
{
    LOGD_VERBOSE((aauto_media_pb_status, "Media Playback Meta Data: Song= %s; "
            "Album= %s; Artist= %s; Playlist= %s; Duration= %d; Rating= %d",
            inMetadata.song.c_str(), inMetadata.album.c_str(),
            inMetadata.artist.c_str(), inMetadata.playlist.c_str(),
            inMetadata.duration_seconds, inMetadata.rating));
    return mCallbacks->mediaPlaybackMetadataCallback(inMetadata);
}

} } /* namespace adit { namespace aauto */
